<?php
$args = array(
    'post_type' => 'courses',
    'posts_per_page' => 5,
    'no_found_rows' => true,
);
$loop = new WP_Query($args);
if ($loop->have_posts()) : ?>
    <!--  section lessons  -->
    <section class="lessons">
        <svg width="352" height="352" viewBox="0 0 352 352" fill="none" xmlns="http://www.w3.org/2000/svg">


            <!-- نصف الدائرة الأولى (الأصغر) -->
            <path class="circle1" d="M 176 46.5 A 129.5 129.5 0 0 1 176 305.5"
                  stroke="#9DAFCD" stroke-opacity="0.67" stroke-width="5"
                  fill="none" stroke-linecap="round"/>

            <!-- نصف الدائرة الثانية (المتوسطة) -->
            <path class="circle2" d="M 175.5 24.5 A 152 152 0 0 1 175.5 328.5"
                  stroke="#9DAFCD" stroke-opacity="0.67" stroke-width="5"
                  fill="none" stroke-linecap="round"/>

            <!-- نصف الدائرة الثالثة (الأكبر) -->
            <path class="circle3" d="M 176 2.5 A 173.5 173.5 0 0 1 176 349.5"
                  stroke="#9DAFCD" stroke-opacity="0.67" stroke-width="5"
                  fill="none" stroke-linecap="round"/>
        </svg>
        <div class="container">
            <h2 class="sec-tit text-center">
                <?php _e('البرامج التدريبية', 'm7md') ?>
            </h2>
            <?php
/*
 ?>
* WordPress Loop للأقسام مع Tabs وأنيميشن
 * Taxonomy: courses_taxonomy
 * Post Type: courses
 */

// جلب جميع الأقسام (Terms)
$terms = get_terms(array(
    'taxonomy' => 'courses_taxonomy',
    'hide_empty' => false,
    'orderby' => 'name',
    'order' => 'ASC'
));

// حساب إجمالي عدد جميع الدورات
$total_courses_args = array(
    'post_type' => 'courses',
    'posts_per_page' => -1,
    'fields' => 'ids'
);
$total_courses_query = new WP_Query($total_courses_args);
$total_courses_count = $total_courses_query->found_posts;
wp_reset_postdata();

if (!empty($terms) && !is_wp_error($terms)) :
?>

            <div class="courses-tabs-wrapper">
                <!-- أزرار الأقسام (Tabs Buttons) -->
                <div class="tabs-buttons">
                    <!-- زر الكل -->
                    <button
                            class="tab-btn active"
                            data-tab="tab-all"
                            data-term-id="all">

                        <!-- اسم القسم -->
                        <span class="tab-name">
                        <?php _e('الجميع', 'm7md') ?>
                        </span>

                        <!-- عدد العناصر
                        <span class="tab-count"><?php echo $total_courses_count; ?></span>-->
                    </button>

                    <?php foreach ($terms as $index => $term) : ?>
                        <button
                                class="tab-btn wow fadeInUp"
                                data-tab="tab-<?php echo $term->term_id; ?>"
                                data-term-id="<?php echo $term->term_id; ?>">

                            <!-- اسم القسم -->
                            <span class="tab-name"><?php echo esc_html($term->name); ?></span>

                            <!-- عدد العناصر
                            <span class="tab-count"><?php echo $term->count; ?></span>-->
                        </button>
                    <?php endforeach; ?>
                </div>

                <!-- محتوى الأقسام (Tabs Content) -->
                <div class="tabs-content">
                    <!-- محتوى الكل -->
                    <div
                            class="tab-content active"
                            id="tab-all"
                            data-term-id="all">

                        <?php
                        // جلب جميع الدورات بدون فلتر
                        $all_courses_args = array(
                            'post_type' => 'courses',
                            'posts_per_page' => 4,
                        );

                        $all_courses_query = new WP_Query($all_courses_args);

                        if ($all_courses_query->have_posts()) : ?>
                            <div class="courses-grid row">

                                    <?php $dc = .2;  while ($all_courses_query->have_posts()) : $all_courses_query->the_post();   ?>

                                        <div class="col-md-3 wow fadeInUp mb-5" data-wow-delay="<?php echo $dc; ?>s">
                                            <article class="course-item" data-course-id="<?php echo get_the_ID(); ?>">

                                                <!-- صورة الدورة -->
                                                <div class="course-image">
                                                    <?php the_post_thumbnail('large', array('alt' => get_the_title() , 'class'=> 'img-fluid'  )); ?>
                                                    <span class="course-badge"> <?php
                                                        $course_terms = get_the_terms(get_the_ID(), 'courses_taxonomy');
                                                        if ($course_terms && !is_wp_error($course_terms)) {
                                                            echo $course_terms[0]->name; // أول قسم
                                                        }
                                                        ?></span>
                                                </div>

                                                <!-- معلومات الدورة -->
                                                <div class="course-info">

                                                    <!-- البيانات العلوية -->
                                                    <div class="course-meta">
                                                        <div class="meta-item">
                                                            <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.01181 0.75C7.14267 0.75 6.96595 3.85321 5.85315 4.94963C4.74035 6.04605 1.28077 4.79243 0.80011 6.73852C0.320454 8.68561 3.43266 9.34625 3.81639 11.0168C4.20213 12.6872 2.30067 15.0343 3.92544 16.2024C5.55021 17.3694 7.29919 14.7279 9.01181 14.7279C10.7244 14.7279 12.4734 17.3694 14.0982 16.2024C15.7229 15.0343 13.8225 12.6872 14.2072 11.0168C14.592 9.34625 17.7032 8.68561 17.2235 6.73852C16.7439 4.79243 13.2833 6.04605 12.1715 4.94963C11.0587 3.85321 10.881 0.75 9.01181 0.75Z" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                            </svg>

                                                            <span><?php the_field('course_ratng'); ?></span>
                                                        </div>
                                                        <div class="meta-item">
                                                            <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <mask id="mask0_70_2080" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="1" y="4" width="15" height="14">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M1.75 4.37524H15.3127V17.9389H1.75V4.37524Z" fill="white"/>
                                                                </mask>
                                                                <g mask="url(#mask0_70_2080)">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.99122 5.68892C5.60709 5.68892 5.35947 5.68892 5.31659 5.69067C4.67084 5.7178 4.07497 5.99167 3.64534 6.46067C3.24459 6.89905 3.03809 7.45905 3.06522 8.04005C3.06522 10.5714 3.06609 14.3707 3.07222 14.5789C3.17197 15.7908 4.30772 16.7174 5.60797 16.6177C8.01422 16.6212 11.579 16.629 11.7461 16.6229C12.3892 16.5967 12.986 16.3237 13.4156 15.8555C13.8172 15.4189 14.0237 14.8589 13.9983 14.2805C13.9975 14.2709 13.9975 14.2613 13.9975 14.2517C13.9983 11.7492 13.9983 7.95255 13.9922 7.74867C13.8933 6.53067 12.7523 5.59267 11.4451 5.69505C9.63734 5.69242 7.17072 5.68892 5.99122 5.68892ZM5.37784 17.9389C3.52809 17.9398 1.91459 16.5223 1.76234 14.6629C1.75972 14.627 1.75097 14.5177 1.75359 8.0698C1.71159 7.16767 2.03884 6.27167 2.67759 5.5743C3.34434 4.8463 4.26397 4.42192 5.26759 4.37905C5.38922 4.3703 9.59622 4.3808 11.3978 4.3843C13.3666 4.24605 15.1437 5.7073 15.3021 7.66817C15.3091 7.76355 15.3117 9.97292 15.31 14.2385C15.3467 15.1625 15.0177 16.0524 14.3825 16.7437C13.7148 17.4708 12.7943 17.8934 11.7916 17.9345C11.6691 17.9433 7.46034 17.9319 5.65609 17.9284C5.56334 17.9354 5.47059 17.9389 5.37784 17.9389Z" fill="black"/>
                                                                </g>
                                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M18.2161 16.0556C17.8215 16.0556 17.4321 15.92 17.111 15.6566L14.2401 13.2976C13.9601 13.0675 13.9199 12.6536 14.15 12.3736C14.3793 12.0945 14.7931 12.0525 15.0731 12.2835L17.9431 14.6425C18.1365 14.8 18.3308 14.7353 18.406 14.6985C18.4813 14.6635 18.6554 14.5541 18.6554 14.3056L18.6659 7.87527C18.6668 7.62677 18.4918 7.5174 18.4165 7.48152C18.3421 7.44652 18.1453 7.3809 17.9536 7.5384L15.0723 9.89652C14.7905 10.1266 14.3784 10.0855 14.1491 9.80377C13.919 9.52377 13.961 9.11077 14.241 8.88152L17.1224 6.52252C17.6509 6.0894 18.3623 6.00452 18.9791 6.2959C19.596 6.58902 19.9793 7.19452 19.9784 7.87702L19.9679 14.3074C19.967 14.9899 19.5829 15.5954 18.9669 15.8859C18.7254 16.0005 18.4699 16.0556 18.2161 16.0556Z" fill="black"/>
                                                            </svg>

                                                            <span>
                                                        <?php if (get_field('courses_paid')):
                                                            $count = count(get_field('courses_paid'));
                                                            echo $count;
                                                        else :
                                                            echo '0';
                                                        endif;
                                                        ?>
                                                        <?php  _e('فيديو', 'm7md') ?>

                                                    </span>
                                                        </div>
                                                        <div class="meta-item">
                                                            <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M10.5 3.0625C6.39888 3.0625 3.0625 6.39888 3.0625 10.5C3.0625 14.6011 6.39888 17.9375 10.5 17.9375C14.6011 17.9375 17.9375 14.6011 17.9375 10.5C17.9375 6.39888 14.6011 3.0625 10.5 3.0625ZM10.5 19.25C5.67525 19.25 1.75 15.3247 1.75 10.5C1.75 5.67525 5.67525 1.75 10.5 1.75C15.3247 1.75 19.25 5.67525 19.25 10.5C19.25 15.3247 15.3247 19.25 10.5 19.25Z" fill="black"/>
                                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M13.5024 13.7309C13.3877 13.7309 13.2722 13.7011 13.1664 13.639L9.86761 11.6711C9.66986 11.5521 9.54736 11.3377 9.54736 11.1067V6.86475C9.54736 6.5025 9.84136 6.2085 10.2036 6.2085C10.5667 6.2085 10.8599 6.5025 10.8599 6.86475V10.734L13.8392 12.5102C14.1499 12.6966 14.2522 13.0991 14.0667 13.4106C13.9434 13.6162 13.7255 13.7309 13.5024 13.7309Z" fill="black"/>
                                                            </svg>

                                                            <span><?php the_field('course_duration'); ?></span>
                                                        </div>




                                                    </div>

                                                    <!-- عنوان الدورة -->
                                                    <h3 class="course-title">
                                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                    </h3>

                                                    <!-- وصف الدورة -->

                                                        <?php the_field('shortdescrtopn'); ?>


                                                    <!-- السعر والتاريخ -->
                                                    <div class="course-footer">
                                                        <div class="course-price">
                                                            <?php if (get_field('course_cost') == 'course_paid') : ?>
                                                                <?php the_field('course_price') ?><?php _e('ريال', 'm7md') ?>
                                                                <?php if (get_field('course_discount') == 'course_paid') : ?>
                                                                    <?php the_field('course_discount') ?><?php _e('ريال', 'm7md') ?>
                                                                <?php endif; ?>
                                                            <?php elseif (get_field('course_cost') == 'course_free') : ?>
                                                                <?php _e('مجانى', 'm7md') ?>
                                                            <?php endif; ?>
                                                        </div>

                                                        <div class="course-date">
                                                            <svg width="20" height="22" viewBox="0 0 20 22" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M18.6663 8.9043H0.842285C0.428285 8.9043 0.0922852 8.5683 0.0922852 8.1543C0.0922852 7.7403 0.428285 7.4043 0.842285 7.4043H18.6663C19.0803 7.4043 19.4163 7.7403 19.4163 8.1543C19.4163 8.5683 19.0803 8.9043 18.6663 8.9043Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M14.2013 12.8096C13.7873 12.8096 13.4473 12.4736 13.4473 12.0596C13.4473 11.6456 13.7783 11.3096 14.1923 11.3096H14.2013C14.6153 11.3096 14.9513 11.6456 14.9513 12.0596C14.9513 12.4736 14.6153 12.8096 14.2013 12.8096Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M9.76377 12.8096C9.34977 12.8096 9.00977 12.4736 9.00977 12.0596C9.00977 11.6456 9.34077 11.3096 9.75477 11.3096H9.76377C10.1778 11.3096 10.5138 11.6456 10.5138 12.0596C10.5138 12.4736 10.1778 12.8096 9.76377 12.8096Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.31701 12.8096C4.90301 12.8096 4.56201 12.4736 4.56201 12.0596C4.56201 11.6456 4.89401 11.3096 5.30801 11.3096H5.31701C5.73101 11.3096 6.06701 11.6456 6.06701 12.0596C6.06701 12.4736 5.73101 12.8096 5.31701 12.8096Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M14.2013 16.6963C13.7873 16.6963 13.4473 16.3603 13.4473 15.9463C13.4473 15.5323 13.7783 15.1963 14.1923 15.1963H14.2013C14.6153 15.1963 14.9513 15.5323 14.9513 15.9463C14.9513 16.3603 14.6153 16.6963 14.2013 16.6963Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M9.76377 16.6963C9.34977 16.6963 9.00977 16.3603 9.00977 15.9463C9.00977 15.5323 9.34077 15.1963 9.75477 15.1963H9.76377C10.1778 15.1963 10.5138 15.5323 10.5138 15.9463C10.5138 16.3603 10.1778 16.6963 9.76377 16.6963Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.31701 16.6963C4.90301 16.6963 4.56201 16.3603 4.56201 15.9463C4.56201 15.5323 4.89401 15.1963 5.30801 15.1963H5.31701C5.73101 15.1963 6.06701 15.5323 6.06701 15.9463C6.06701 16.3603 5.73101 16.6963 5.31701 16.6963Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M13.7935 4.791C13.3795 4.791 13.0435 4.455 13.0435 4.041V0.75C13.0435 0.336 13.3795 0 13.7935 0C14.2075 0 14.5435 0.336 14.5435 0.75V4.041C14.5435 4.455 14.2075 4.791 13.7935 4.791Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.71533 4.791C5.30133 4.791 4.96533 4.455 4.96533 4.041V0.75C4.96533 0.336 5.30133 0 5.71533 0C6.12933 0 6.46533 0.336 6.46533 0.75V4.041C6.46533 4.455 6.12933 4.791 5.71533 4.791Z" fill="#0A033C"/>
<mask id="mask0_283_518" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="1" width="20" height="21">
<path fill-rule="evenodd" clip-rule="evenodd" d="M0 1.5791H19.5V21.5H0V1.5791Z" fill="white"/>
</mask>
<g mask="url(#mask0_283_518)">
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.521 3.0791C2.928 3.0791 1.5 4.4621 1.5 6.9731V16.0221C1.5 18.5881 2.928 20.0001 5.521 20.0001H13.979C16.572 20.0001 18 18.6141 18 16.0981V6.9731C18.004 5.7381 17.672 4.7781 17.013 4.1181C16.335 3.4381 15.29 3.0791 13.988 3.0791H5.521ZM13.979 21.5001H5.521C2.116 21.5001 0 19.4011 0 16.0221V6.9731C0 3.6451 2.116 1.5791 5.521 1.5791H13.988C15.697 1.5791 17.11 2.0911 18.075 3.0581C19.012 3.9991 19.505 5.3521 19.5 6.9751V16.0981C19.5 19.4301 17.384 21.5001 13.979 21.5001Z" fill="#0A033C"/>
</g>
</svg>


                                                            <span><?php the_field('course_timing'); ?></span>
                                                        </div>
                                                    </div>

                                                </div>

                                            </article>
                                        </div>

                                    <?php  $dc +=.2; endwhile; ?>
                                </div>

                        <?php else : ?>
                            <p class="no-courses">
                                <?php _e('لا توجد دورات', 'm7md') ?>
                            </p>
                        <?php endif; ?>

                        <?php wp_reset_postdata(); ?>
                    </div>

                    <?php foreach ($terms as $index => $term) :

                        // جلب العناصر الخاصة بكل قسم
                        $args = array(
                            'post_type' => 'courses',
                            'posts_per_page' => 4,
                            'tax_query' => array(
                                array(
                                    'taxonomy' => 'courses_taxonomy',
                                    'field' => 'term_id',
                                    'terms' => $term->term_id,
                                ),
                            ),
                        );

                        $query = new WP_Query($args);
                        ?>

                        <div
                                class="tab-content"
                                id="tab-<?php echo $term->term_id; ?>"
                                data-term-id="<?php echo $term->term_id; ?>">

                            <?php if ($query->have_posts()) : ?>
                                <div class="courses-grid row">
                                    <?php while ($query->have_posts()) : $query->the_post(); ?>

                                        <div class="col-md-3">
                                            <article class="course-item" data-course-id="<?php echo get_the_ID(); ?>">

                                                <!-- صورة الدورة -->
                                                <div class="course-image">
                                                    <?php the_post_thumbnail('large', array('alt' => get_the_title() , 'class'=> 'img-fluid'  )); ?>
                                                    <span class="course-badge"> <?php
                                                        $course_terms = get_the_terms(get_the_ID(), 'courses_taxonomy');
                                                        if ($course_terms && !is_wp_error($course_terms)) {
                                                            echo $course_terms[0]->name; // أول قسم
                                                        }
                                                        ?></span>
                                                </div>

                                                <!-- معلومات الدورة -->
                                                <div class="course-info">

                                                    <!-- البيانات العلوية -->
                                                    <div class="course-meta">
                                                        <div class="meta-item">
                                                            <svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.01181 0.75C7.14267 0.75 6.96595 3.85321 5.85315 4.94963C4.74035 6.04605 1.28077 4.79243 0.80011 6.73852C0.320454 8.68561 3.43266 9.34625 3.81639 11.0168C4.20213 12.6872 2.30067 15.0343 3.92544 16.2024C5.55021 17.3694 7.29919 14.7279 9.01181 14.7279C10.7244 14.7279 12.4734 17.3694 14.0982 16.2024C15.7229 15.0343 13.8225 12.6872 14.2072 11.0168C14.592 9.34625 17.7032 8.68561 17.2235 6.73852C16.7439 4.79243 13.2833 6.04605 12.1715 4.94963C11.0587 3.85321 10.881 0.75 9.01181 0.75Z" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                            </svg>

                                                            <span><?php the_field('course_ratng'); ?></span>
                                                        </div>
                                                        <div class="meta-item">
                                                            <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <mask id="mask0_70_2080" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="1" y="4" width="15" height="14">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M1.75 4.37524H15.3127V17.9389H1.75V4.37524Z" fill="white"/>
                                                                </mask>
                                                                <g mask="url(#mask0_70_2080)">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.99122 5.68892C5.60709 5.68892 5.35947 5.68892 5.31659 5.69067C4.67084 5.7178 4.07497 5.99167 3.64534 6.46067C3.24459 6.89905 3.03809 7.45905 3.06522 8.04005C3.06522 10.5714 3.06609 14.3707 3.07222 14.5789C3.17197 15.7908 4.30772 16.7174 5.60797 16.6177C8.01422 16.6212 11.579 16.629 11.7461 16.6229C12.3892 16.5967 12.986 16.3237 13.4156 15.8555C13.8172 15.4189 14.0237 14.8589 13.9983 14.2805C13.9975 14.2709 13.9975 14.2613 13.9975 14.2517C13.9983 11.7492 13.9983 7.95255 13.9922 7.74867C13.8933 6.53067 12.7523 5.59267 11.4451 5.69505C9.63734 5.69242 7.17072 5.68892 5.99122 5.68892ZM5.37784 17.9389C3.52809 17.9398 1.91459 16.5223 1.76234 14.6629C1.75972 14.627 1.75097 14.5177 1.75359 8.0698C1.71159 7.16767 2.03884 6.27167 2.67759 5.5743C3.34434 4.8463 4.26397 4.42192 5.26759 4.37905C5.38922 4.3703 9.59622 4.3808 11.3978 4.3843C13.3666 4.24605 15.1437 5.7073 15.3021 7.66817C15.3091 7.76355 15.3117 9.97292 15.31 14.2385C15.3467 15.1625 15.0177 16.0524 14.3825 16.7437C13.7148 17.4708 12.7943 17.8934 11.7916 17.9345C11.6691 17.9433 7.46034 17.9319 5.65609 17.9284C5.56334 17.9354 5.47059 17.9389 5.37784 17.9389Z" fill="black"/>
                                                                </g>
                                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M18.2161 16.0556C17.8215 16.0556 17.4321 15.92 17.111 15.6566L14.2401 13.2976C13.9601 13.0675 13.9199 12.6536 14.15 12.3736C14.3793 12.0945 14.7931 12.0525 15.0731 12.2835L17.9431 14.6425C18.1365 14.8 18.3308 14.7353 18.406 14.6985C18.4813 14.6635 18.6554 14.5541 18.6554 14.3056L18.6659 7.87527C18.6668 7.62677 18.4918 7.5174 18.4165 7.48152C18.3421 7.44652 18.1453 7.3809 17.9536 7.5384L15.0723 9.89652C14.7905 10.1266 14.3784 10.0855 14.1491 9.80377C13.919 9.52377 13.961 9.11077 14.241 8.88152L17.1224 6.52252C17.6509 6.0894 18.3623 6.00452 18.9791 6.2959C19.596 6.58902 19.9793 7.19452 19.9784 7.87702L19.9679 14.3074C19.967 14.9899 19.5829 15.5954 18.9669 15.8859C18.7254 16.0005 18.4699 16.0556 18.2161 16.0556Z" fill="black"/>
                                                            </svg>

                                                            <span>
                                                        <?php if (get_field('courses_paid')):
                                                            $count = count(get_field('courses_paid'));
                                                            echo $count;
                                                        else :
                                                            echo '0';
                                                        endif;
                                                        ?>
                                                        <?php  _e('فيديو', 'm7md') ?>

                                                    </span>
                                                        </div>
                                                        <div class="meta-item">
                                                            <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M10.5 3.0625C6.39888 3.0625 3.0625 6.39888 3.0625 10.5C3.0625 14.6011 6.39888 17.9375 10.5 17.9375C14.6011 17.9375 17.9375 14.6011 17.9375 10.5C17.9375 6.39888 14.6011 3.0625 10.5 3.0625ZM10.5 19.25C5.67525 19.25 1.75 15.3247 1.75 10.5C1.75 5.67525 5.67525 1.75 10.5 1.75C15.3247 1.75 19.25 5.67525 19.25 10.5C19.25 15.3247 15.3247 19.25 10.5 19.25Z" fill="black"/>
                                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M13.5024 13.7309C13.3877 13.7309 13.2722 13.7011 13.1664 13.639L9.86761 11.6711C9.66986 11.5521 9.54736 11.3377 9.54736 11.1067V6.86475C9.54736 6.5025 9.84136 6.2085 10.2036 6.2085C10.5667 6.2085 10.8599 6.5025 10.8599 6.86475V10.734L13.8392 12.5102C14.1499 12.6966 14.2522 13.0991 14.0667 13.4106C13.9434 13.6162 13.7255 13.7309 13.5024 13.7309Z" fill="black"/>
                                                            </svg>

                                                            <span><?php the_field('course_duration'); ?></span>
                                                        </div>




                                                    </div>

                                                    <!-- عنوان الدورة -->
                                                    <h3 class="course-title">
                                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                    </h3>

                                                    <!-- وصف الدورة -->

                                                        <?php the_field('shortdescrtopn'); ?>


                                                    <!-- السعر والتاريخ -->
                                                    <div class="course-footer">
                                                        <div class="course-price">
                                                            <?php if (get_field('course_cost') == 'course_paid') : ?>
                                                                <?php the_field('course_price') ?><?php _e('ريال', 'm7md') ?>
                                                                <?php if (get_field('course_discount') == 'course_paid') : ?>
                                                                    <?php the_field('course_discount') ?><?php _e('ريال', 'm7md') ?>
                                                                <?php endif; ?>
                                                            <?php elseif (get_field('course_cost') == 'course_free') : ?>
                                                                <?php _e('مجانى', 'm7md') ?>
                                                            <?php endif; ?>
                                                        </div>

                                                        <div class="course-date">
                                                            <svg width="20" height="22" viewBox="0 0 20 22" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M18.6663 8.9043H0.842285C0.428285 8.9043 0.0922852 8.5683 0.0922852 8.1543C0.0922852 7.7403 0.428285 7.4043 0.842285 7.4043H18.6663C19.0803 7.4043 19.4163 7.7403 19.4163 8.1543C19.4163 8.5683 19.0803 8.9043 18.6663 8.9043Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M14.2013 12.8096C13.7873 12.8096 13.4473 12.4736 13.4473 12.0596C13.4473 11.6456 13.7783 11.3096 14.1923 11.3096H14.2013C14.6153 11.3096 14.9513 11.6456 14.9513 12.0596C14.9513 12.4736 14.6153 12.8096 14.2013 12.8096Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M9.76377 12.8096C9.34977 12.8096 9.00977 12.4736 9.00977 12.0596C9.00977 11.6456 9.34077 11.3096 9.75477 11.3096H9.76377C10.1778 11.3096 10.5138 11.6456 10.5138 12.0596C10.5138 12.4736 10.1778 12.8096 9.76377 12.8096Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.31701 12.8096C4.90301 12.8096 4.56201 12.4736 4.56201 12.0596C4.56201 11.6456 4.89401 11.3096 5.30801 11.3096H5.31701C5.73101 11.3096 6.06701 11.6456 6.06701 12.0596C6.06701 12.4736 5.73101 12.8096 5.31701 12.8096Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M14.2013 16.6963C13.7873 16.6963 13.4473 16.3603 13.4473 15.9463C13.4473 15.5323 13.7783 15.1963 14.1923 15.1963H14.2013C14.6153 15.1963 14.9513 15.5323 14.9513 15.9463C14.9513 16.3603 14.6153 16.6963 14.2013 16.6963Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M9.76377 16.6963C9.34977 16.6963 9.00977 16.3603 9.00977 15.9463C9.00977 15.5323 9.34077 15.1963 9.75477 15.1963H9.76377C10.1778 15.1963 10.5138 15.5323 10.5138 15.9463C10.5138 16.3603 10.1778 16.6963 9.76377 16.6963Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.31701 16.6963C4.90301 16.6963 4.56201 16.3603 4.56201 15.9463C4.56201 15.5323 4.89401 15.1963 5.30801 15.1963H5.31701C5.73101 15.1963 6.06701 15.5323 6.06701 15.9463C6.06701 16.3603 5.73101 16.6963 5.31701 16.6963Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M13.7935 4.791C13.3795 4.791 13.0435 4.455 13.0435 4.041V0.75C13.0435 0.336 13.3795 0 13.7935 0C14.2075 0 14.5435 0.336 14.5435 0.75V4.041C14.5435 4.455 14.2075 4.791 13.7935 4.791Z" fill="#0A033C"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.71533 4.791C5.30133 4.791 4.96533 4.455 4.96533 4.041V0.75C4.96533 0.336 5.30133 0 5.71533 0C6.12933 0 6.46533 0.336 6.46533 0.75V4.041C6.46533 4.455 6.12933 4.791 5.71533 4.791Z" fill="#0A033C"/>
<mask id="mask0_283_518" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="1" width="20" height="21">
<path fill-rule="evenodd" clip-rule="evenodd" d="M0 1.5791H19.5V21.5H0V1.5791Z" fill="white"/>
</mask>
<g mask="url(#mask0_283_518)">
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.521 3.0791C2.928 3.0791 1.5 4.4621 1.5 6.9731V16.0221C1.5 18.5881 2.928 20.0001 5.521 20.0001H13.979C16.572 20.0001 18 18.6141 18 16.0981V6.9731C18.004 5.7381 17.672 4.7781 17.013 4.1181C16.335 3.4381 15.29 3.0791 13.988 3.0791H5.521ZM13.979 21.5001H5.521C2.116 21.5001 0 19.4011 0 16.0221V6.9731C0 3.6451 2.116 1.5791 5.521 1.5791H13.988C15.697 1.5791 17.11 2.0911 18.075 3.0581C19.012 3.9991 19.505 5.3521 19.5 6.9751V16.0981C19.5 19.4301 17.384 21.5001 13.979 21.5001Z" fill="#0A033C"/>
</g>
</svg>


                                                            <span><?php the_field('course_timing'); ?></span>
                                                        </div>
                                                    </div>

                                                </div>

                                            </article>
                                        </div>

                                    <?php endwhile; ?>
                                </div>
                            <?php else : ?>
                                <p class="no-courses"> <?php _e('لا توجد دورات', 'm7md') ?></p>
                            <?php endif; ?>

                            <?php wp_reset_postdata(); ?>
                        </div>

                    <?php endforeach; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </section>
    <!--  //section lessons  -->

<?php endif;
wp_reset_postdata(); ?>

